﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Reporting.WinForms;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{
    /// <summary>
    /// VbecsReportViewer
    /// </summary>
    public class VbecsReportViewer : Microsoft.Reporting.WinForms.ReportViewer
    {
        /// <summary>
        /// VbecsReportViewer
        /// </summary>
        public VbecsReportViewer()
        {
            this.ReportExport += new ExportEventHandler(this.Report_Export);
        }

        /// <summary>
        /// Report_Export
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void Report_Export(object sender, ReportExportEventArgs e)
        {
            string fileNameWithPath = "";

            DlgExportReport dlg = new DlgExportReport();
            if (e.Extension.Name.ToLower().Contains("pdf"))
            {
                dlg.Extension = ".pdf";
            }
            else if (e.Extension.Name.ToLower().Contains("excel"))
            {
                dlg.Extension = ".xls";
            }
            else if (e.Extension.Name.ToLower().Contains("word"))
            {
                dlg.Extension = ".doc";
            }

            if (Common.VbecsConfig.Current.ReportExportPath.EndsWith("\\"))
                fileNameWithPath = Common.VbecsConfig.Current.ReportExportPath;
            else
                fileNameWithPath = Common.VbecsConfig.Current.ReportExportPath + "\\";

            dlg.ExportDir = fileNameWithPath;

            if (dlg.ShowDialog() == DialogResult.OK)
            {
                fileNameWithPath = fileNameWithPath + dlg.FileName + dlg.Extension;
                if (((ReportViewer)sender).ExportDialog(e.Extension, e.DeviceInfo, fileNameWithPath) == DialogResult.OK)
                    MessageBox.Show(Common.StrRes.ConfMsg.Common.ReportExportSuccess(fileNameWithPath).ResString, "Report Export Success", MessageBoxButtons.OK, MessageBoxIcon.Information);
                e.Cancel = true;
            }
            else
            {
                e.Cancel = true;
            }
        }
    }
}
